package w83a.w83aOperacionesPaso.w83aResultados;
  


import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.HSSFColor.GREY_40_PERCENT;





// TODO: Auto-generated Javadoc
/**
 * The Class .
 * 
 * @author eaguinaco
 * @version
 */
public class W83aClsEstilosExcel {
	
	/**
	 * Instantiates a new v55 cls idioma.
	 */
	private W83aClsEstilosExcel(){}
	
 	/**
	  * estiloNegritaTexto
	  * 
	  * @param wb HSSFWorkbook
	  * @return HSSFCellStyle
	  */    
    public static HSSFCellStyle estiloNegritaTexto (HSSFWorkbook wb){
    	
    	
      	 HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
		 styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.	
		 HSSFFont fuente = wb.createFont();
		 fuente.setFontHeightInPoints((short) 9);
		 fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		 styleNumeroPar.setFont(fuente);			 
		 styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		 styleNumeroPar.setWrapText(true); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
		 styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
		 styleNumeroPar.setBorderRight((short) 1);
		 styleNumeroPar.setBorderLeft((short) 1);
		 styleNumeroPar.setBorderBottom((short) 1);
		 styleNumeroPar.setBorderTop((short) 1);
		 
		 return styleNumeroPar;
    }    
    /**
     * estiloNegritaTexto
     * 
     * @param wb HSSFWorkbook
     * @return HSSFCellStyle
     */    
    public static HSSFCellStyle estiloNegritaNumero (HSSFWorkbook wb){
    	
   		HSSFDataFormat format = wb.createDataFormat();
   		HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
   		styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_RIGHT); // Estilo alineacin dercecha.			 
		HSSFFont fuente = wb.createFont();
	    fuente.setFontHeightInPoints((short) 9);
	    fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		styleNumeroPar.setFont(fuente);
   		styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
   		styleNumeroPar.setDataFormat(format.getFormat("0")); // Estilo de formato de nmero para que siempre saque como mnimo dos dgitos
   		styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
   		styleNumeroPar.setBorderRight((short) 1);
   		styleNumeroPar.setBorderLeft((short) 1);
   		styleNumeroPar.setBorderBottom((short) 1);
   		styleNumeroPar.setBorderTop((short) 1);
		 
		 return styleNumeroPar;
    }    
    /**
     * estiloNegritaTexto
     * 
     * @param wb HSSFWorkbook
     * @return HSSFCellStyle
     */    
    public static HSSFCellStyle estiloNegritaNumero8 (HSSFWorkbook wb){
    	
    	HSSFDataFormat format = wb.createDataFormat();
    	HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
    	styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_RIGHT); // Estilo alineacin dercecha.			 
    	HSSFFont fuente = wb.createFont();
    	fuente.setFontHeightInPoints((short) 8);
    	fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
    	styleNumeroPar.setFont(fuente);
    	styleNumeroPar.setDataFormat(format.getFormat("0")); // Estilo de formato de nmero para que siempre saque como mnimo dos dgitos
    	styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
    	styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
    	styleNumeroPar.setBorderRight((short) 1);
    	styleNumeroPar.setBorderBottom((short) 1);
    	styleNumeroPar.setBorderLeft((short) 1);
    	styleNumeroPar.setBorderTop((short) 1);
    	
    	return styleNumeroPar;
    }    
    
    /**
     * estiloParCadena
     * 
     * @param wb HSSFWorkbook
     * @return HSSFCellStyle
     */    
    public static HSSFCellStyle estiloParCadena (HSSFWorkbook wb){
    	
    	
    	HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
    	styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.	
    	HSSFFont fuente = wb.createFont();
    	fuente.setFontHeightInPoints((short) 8);
    	styleNumeroPar.setFont(fuente);			 
    	styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
    	styleNumeroPar.setWrapText(true); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
    	styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
    	styleNumeroPar.setBorderRight((short) 1);
    	styleNumeroPar.setBorderLeft((short) 1);
    	styleNumeroPar.setBorderBottom((short) 1);
    	styleNumeroPar.setBorderTop((short) 1);
    	
    	return styleNumeroPar;
    } 
     /**
     * estiloParCadena
     * 
     * @param wb HSSFWorkbook
     * @return HSSFCellStyle
     */    
    public static HSSFCellStyle estiloParCadenaNoBordes (HSSFWorkbook wb){
    	
    	
    	HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
    	styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.	
    	HSSFFont fuente = wb.createFont();
    	fuente.setFontHeightInPoints((short) 8);
    	styleNumeroPar.setFont(fuente);			 
    	styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
    	styleNumeroPar.setWrapText(true); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
    	styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
    	styleNumeroPar.setBorderRight((short) 0);
    	styleNumeroPar.setBorderLeft((short) 0);
    	styleNumeroPar.setBorderBottom((short) 0);
    	styleNumeroPar.setBorderTop((short) 0);
    	
    	return styleNumeroPar;
    }    
       
    /**
     * estiloParCadenaCentrado
     * 
     * @param wb HSSFWorkbook
     * @return HSSFCellStyle
     */    
    public static HSSFCellStyle estiloParCadenaCentrado (HSSFWorkbook wb){
    	
    	
    	HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
    	styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_CENTER); // Estilo alineacin dercecha.	
    	HSSFFont fuente = wb.createFont();
    	fuente.setFontHeightInPoints((short) 8);
    	styleNumeroPar.setFont(fuente);			 
    	styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
    	styleNumeroPar.setWrapText(true); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
    	styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
    	styleNumeroPar.setBorderRight((short) 1);
    	styleNumeroPar.setBorderLeft((short) 1);
    	styleNumeroPar.setBorderBottom((short) 1);
    	styleNumeroPar.setBorderTop((short) 1);
    	
    	return styleNumeroPar;
    } 
    /**
     * estiloParCadenaNoJustif
     * 
     * @param wb HSSFWorkbook
     * @return HSSFCellStyle
     */    
    public static HSSFCellStyle estiloParCadenaNoJustif (HSSFWorkbook wb){
    	
    	
    	HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
    	styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.	
    	HSSFFont fuente = wb.createFont();
    	fuente.setFontHeightInPoints((short) 8);
    	styleNumeroPar.setFont(fuente);			 
    	styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
    	styleNumeroPar.setWrapText(false); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
    	styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
    	styleNumeroPar.setBorderRight((short) 1);
    	styleNumeroPar.setBorderLeft((short) 1);
    	styleNumeroPar.setBorderBottom((short) 1);
    	styleNumeroPar.setBorderTop((short) 1);
    	
    	return styleNumeroPar;
    }    
    
   /**
     * estiloParCadenaNoJustif
     * 
     * @param wb HSSFWorkbook
     * @return HSSFCellStyle
     */    
    public static HSSFCellStyle estiloParCadenaJustifCombinada (HSSFWorkbook wb){
    	
    	
    	HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
    	styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_JUSTIFY); // Estilo alineacin dercecha.	
    	HSSFFont fuente = wb.createFont();
    	fuente.setFontHeightInPoints((short) 8);
    	styleNumeroPar.setFont(fuente);			 
    	styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
    	styleNumeroPar.setWrapText(false); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
    	styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
    	styleNumeroPar.setBorderRight((short) 1);
    	styleNumeroPar.setBorderLeft((short) 1);
    	styleNumeroPar.setBorderBottom((short) 1);
    	styleNumeroPar.setBorderTop((short) 1);
    	styleNumeroPar.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
    	
    	return styleNumeroPar;
    }    
    
    
    /**
	  * estiloParNumero
	  * 
	  * @param wb HSSFWorkbook
	  * @return HSSFCellStyle
	  */    
   public static HSSFCellStyle estiloParNumero (HSSFWorkbook wb){
   	
   		HSSFDataFormat format = wb.createDataFormat();
   		HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
   		styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_RIGHT); // Estilo alineacin dercecha.			 
		HSSFFont fuente = wb.createFont();
	    fuente.setFontHeightInPoints((short) 8);
		styleNumeroPar.setFont(fuente);
   		styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
   		styleNumeroPar.setDataFormat(format.getFormat("0")); // Estilo de formato de nmero para que siempre saque como mnimo dos dgitos
   		styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
   		styleNumeroPar.setBorderRight((short) 1);
   		styleNumeroPar.setBorderLeft((short) 1);
   		styleNumeroPar.setBorderBottom((short) 1);
   		styleNumeroPar.setBorderTop((short) 1);
		 
		 return styleNumeroPar;
   }    
   /**
	  * estiloParNumero
	  * 
	  * @param wb HSSFWorkbook
	  * @return HSSFCellStyle
	  */    
 public static HSSFCellStyle estiloParNumeroCentrado (HSSFWorkbook wb){
 	
 		HSSFDataFormat format = wb.createDataFormat();
 		HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
 		styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_CENTER); // Estilo alineacin centrado.			 
		HSSFFont fuente = wb.createFont();
	    fuente.setFontHeightInPoints((short) 8);
		styleNumeroPar.setFont(fuente);
 		styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
 		styleNumeroPar.setDataFormat(format.getFormat("0")); // Estilo de formato de nmero para que siempre saque como mnimo dos dgitos
 		styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
 		styleNumeroPar.setBorderRight((short) 1);
 		styleNumeroPar.setBorderLeft((short) 1);
 		styleNumeroPar.setBorderBottom((short) 1);
 		styleNumeroPar.setBorderTop((short) 1);
		 
		 return styleNumeroPar;
 }    
   /**
    * estiloParNumeroFormato
    * Define el formato para n decimales de modo 0.00
    * 
    * @param wb HSSFWorkbook
    * @return HSSFCellStyle
    */    
   public static HSSFCellStyle estiloParNumeroFormato (HSSFWorkbook wb){
	   
	   HSSFDataFormat format = wb.createDataFormat();
	   HSSFCellStyle styleNumeroParFormato =  wb.createCellStyle();
	   styleNumeroParFormato.setAlignment(HSSFCellStyle.ALIGN_RIGHT); // Estilo alineacin dercecha.
		 HSSFFont fuente = wb.createFont();
		 fuente.setFontHeightInPoints((short) 8);
		 styleNumeroParFormato.setFont(fuente);
	   styleNumeroParFormato.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	   styleNumeroParFormato.setDataFormat(format.getFormat("#,##0.00")); // Estilo de formato de nmero para que siempre saque como mnimo dos dgitos
	   styleNumeroParFormato.setFillForegroundColor(HSSFColor.WHITE.index);
	   styleNumeroParFormato.setBorderRight((short) 1);
	   styleNumeroParFormato.setBorderLeft((short) 1);
	   styleNumeroParFormato.setBorderBottom((short) 1);
	   styleNumeroParFormato.setBorderTop((short) 1);
	   
	   return styleNumeroParFormato;
   }
   
   public static HSSFCellStyle styleCentradoNumeroFormateado (HSSFWorkbook wb){
		
		HSSFCellStyle centrado =  wb.createCellStyle();
		HSSFDataFormat format = wb.createDataFormat();
		centrado = wb.createCellStyle();// Estilo
		centrado.setAlignment(HSSFCellStyle.ALIGN_CENTER);
		centrado.setDataFormat(format.getFormat("#,###0"));
		return centrado;
	}
   
   public static HSSFCellStyle styleDerechaNumeroFormateado (HSSFWorkbook wb){
		
		HSSFCellStyle centrado =  wb.createCellStyle();
		HSSFDataFormat format = wb.createDataFormat();
		centrado = wb.createCellStyle();// Estilo
		centrado.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
		centrado.setDataFormat(format.getFormat("#,###0"));
		return centrado;
	}
   
   public static HSSFCellStyle styleBordeArribaFormateado (HSSFWorkbook wb){
		
		HSSFCellStyle bordeArriba =  wb.createCellStyle();
		HSSFDataFormat format = wb.createDataFormat();
		bordeArriba = wb.createCellStyle();// Estilo
		bordeArriba.setBorderTop(HSSFCellStyle.BORDER_THIN);
		bordeArriba.setDataFormat(format.getFormat("#,###0"));
		return bordeArriba;
	}
   
   public static HSSFCellStyle sytleNegritaFormateado (HSSFWorkbook wb){
   	
  		HSSFDataFormat format = wb.createDataFormat();
  		HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
  		styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_RIGHT); // Estilo alineacin dercecha.			 
		HSSFFont fuente = wb.createFont();
	    fuente.setFontHeightInPoints((short) 9);
	    fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		styleNumeroPar.setFont(fuente);
  		styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
  		styleNumeroPar.setDataFormat(format.getFormat("#,###0"));
  		styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
  		styleNumeroPar.setBorderRight((short) 1);
  		styleNumeroPar.setBorderLeft((short) 1);
  		styleNumeroPar.setBorderBottom((short) 1);
  		styleNumeroPar.setBorderTop((short) 1);
		 
		 return styleNumeroPar;
   } 
   
   public static HSSFCellStyle styleTextoParNumeroCentradoFormateado (HSSFWorkbook wb){
	 	
		HSSFDataFormat format = wb.createDataFormat();
		HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
		styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_CENTER); // Estilo alineacin centrado.			 
		HSSFFont fuente = wb.createFont();
	    fuente.setFontHeightInPoints((short) 8);
		styleNumeroPar.setFont(fuente);
		styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		styleNumeroPar.setDataFormat(format.getFormat("#,###0"));
		styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
		styleNumeroPar.setBorderRight((short) 1);
		styleNumeroPar.setBorderLeft((short) 1);
		styleNumeroPar.setBorderBottom((short) 1);
		styleNumeroPar.setBorderTop((short) 1);
		 
		 return styleNumeroPar;
}
   /**
    * estiloParNumeroFormato
    * Define el formato para n decimales de modo 0.00
    * 
    * @param wb HSSFWorkbook
    * @return HSSFCellStyle
    */    
   public static HSSFCellStyle estiloParNumeroPorcentaje (HSSFWorkbook wb){
	   
	   HSSFDataFormat format = wb.createDataFormat();
	   HSSFCellStyle styleNumeroParFormato =  wb.createCellStyle();
	   styleNumeroParFormato.setAlignment(HSSFCellStyle.ALIGN_RIGHT); // Estilo alineacin dercecha.
		 HSSFFont fuente = wb.createFont();
		 fuente.setFontHeightInPoints((short) 8);
		 styleNumeroParFormato.setFont(fuente);
	   styleNumeroParFormato.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	   styleNumeroParFormato.setFillForegroundColor(HSSFColor.WHITE.index);
	   styleNumeroParFormato.setBorderRight((short) 1);
	   styleNumeroParFormato.setBorderLeft((short) 1);
	   styleNumeroParFormato.setBorderBottom((short) 1);
	   styleNumeroParFormato.setBorderTop((short) 1);
	   styleNumeroParFormato.setDataFormat(format.getFormat("0.00%")); 
		
	  
	   
	   return styleNumeroParFormato;
   }    
   
   /**
	  * estiloFinCabecera
	  * 
	  * @param wb HSSFWorkbook
	  * @return HSSFCellStyle
	  */    
 public static HSSFCellStyle estiloFinCabeceraPar (HSSFWorkbook wb){
 	
	 HSSFCellStyle stylefincabecera = wb.createCellStyle();
	 HSSFDataFormat format = wb.createDataFormat();
	 stylefincabecera.setBorderBottom(HSSFCellStyle.BORDER_MEDIUM);
	 HSSFFont fuente = wb.createFont();
	 fuente.setFontHeightInPoints((short) 8);
	 stylefincabecera.setFont(fuente);
	 stylefincabecera.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin centrado.			 
	 stylefincabecera.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	 stylefincabecera.setDataFormat(format.getFormat("0")); // Estilo de formato de nmero para que siempre saque como mnimo dos dgitos
	 stylefincabecera.setFillForegroundColor(HSSFColor.WHITE.index);
		 
		 return stylefincabecera;
 }    
   
 /**
  * estiloFinCabecera
  * 
  * @param wb HSSFWorkbook
  * @return HSSFCellStyle
  */    
public static HSSFCellStyle estiloFinCabeceraInpar (HSSFWorkbook wb){
	
 HSSFCellStyle stylefincabecera = wb.createCellStyle();
 HSSFDataFormat format = wb.createDataFormat();
 stylefincabecera.setBorderBottom(HSSFCellStyle.BORDER_MEDIUM);
 HSSFFont fuente = wb.createFont();
 fuente.setFontHeightInPoints((short) 8);
 stylefincabecera.setFont(fuente);
 stylefincabecera.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin centrado.			 
 stylefincabecera.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
 stylefincabecera.setDataFormat(format.getFormat("0")); // Estilo de formato de nmero para que siempre saque como mnimo dos dgitos
 stylefincabecera.setFillForegroundColor(GREY.index);
	 
	 return stylefincabecera;
}    
  
	/**
	 * estiloInparCadena
	 * 
	 * @param wb HSSFWorkbook
	 * @return HSSFCellStyle
	 */    
	public static HSSFCellStyle estiloInparCadena10 (HSSFWorkbook wb){
		
		
		HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
		styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.			 
		styleTextoImpar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		styleTextoImpar.setWrapText(true);
		 HSSFFont fuente = wb.createFont();
	fuente.setFontHeightInPoints((short) 10);
	styleTextoImpar.setFont(fuente);
		styleTextoImpar.setFillForegroundColor(GREY.index);
		styleTextoImpar.setBorderRight((short) 1);
		styleTextoImpar.setBorderLeft((short) 1);
		styleTextoImpar.setBorderBottom((short) 1);
		styleTextoImpar.setBorderTop((short) 1);
		return styleTextoImpar;
	}   
	/**
	 * estiloInparCadena
	 * 
	 * @param wb HSSFWorkbook
	 * @return HSSFCellStyle
	 */    
	public static HSSFCellStyle estiloParCadena10 (HSSFWorkbook wb){
		
		
		HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
    	styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_JUSTIFY); // Estilo alineacin dercecha.	
    	HSSFFont fuente = wb.createFont();
    	fuente.setFontHeightInPoints((short) 10);
    	styleNumeroPar.setFont(fuente);			 
    	styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
    	styleNumeroPar.setWrapText(false); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
    	styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
    	styleNumeroPar.setBorderRight((short) 1);
    	styleNumeroPar.setBorderLeft((short) 1);
    	styleNumeroPar.setBorderBottom((short) 1);
    	styleNumeroPar.setBorderTop((short) 1);
    	styleNumeroPar.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
    	
    	return styleNumeroPar;
	}   
	/**
	 * estiloInparCadena
	 * 
	 * @param wb HSSFWorkbook
	 * @return HSSFCellStyle
	 */    
	public static HSSFCellStyle estiloInparCadena10Center (HSSFWorkbook wb){
		
		
		HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
		styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_CENTER); // Estilo alineacin dercecha.			 
		styleTextoImpar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		styleTextoImpar.setWrapText(true);
		HSSFFont fuente = wb.createFont();
		fuente.setFontHeightInPoints((short) 10);
		styleTextoImpar.setFont(fuente);
		styleTextoImpar.setFillForegroundColor(GREY_40_PERCENT.index);
		styleTextoImpar.setBorderRight((short) 1);
		styleTextoImpar.setBorderLeft((short) 1);
		styleTextoImpar.setBorderBottom((short) 1);
		styleTextoImpar.setBorderTop((short) 1);
		return styleTextoImpar;
	}   
	/**
	 * estiloInparCadena
	 * 
	 * @param wb HSSFWorkbook
	 * @return HSSFCellStyle
	 */    
	public static HSSFCellStyle estiloCadena10 (HSSFWorkbook wb){
		
		
		HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
		styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.	
		styleTextoImpar.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP); // Estilo alineacin dercecha.		
		
		 HSSFFont fuente = wb.createFont();
		fuente.setFontHeightInPoints((short) 10);
		styleTextoImpar.setFont(fuente);
			
		return styleTextoImpar;
	}     
	/**
	 * estiloInparCadena
	 * 
	 * @param wb HSSFWorkbook
	 * @return HSSFCellStyle
	 */    
	public static HSSFCellStyle estiloCadena9 (HSSFWorkbook wb){
		
		
		HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
		styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.	
		styleTextoImpar.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP); // Estilo alineacin dercecha.		
		
		 HSSFFont fuente = wb.createFont();
		fuente.setFontHeightInPoints((short) 9);
		styleTextoImpar.setFont(fuente);
			
		return styleTextoImpar;
	}     
	
public static HSSFCellStyle estiloCadena9Justif (HSSFWorkbook wb){
		
		
		HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
		styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.	
		styleTextoImpar.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP); // Estilo alineacin dercecha.		
		styleTextoImpar.setVerticalAlignment(HSSFCellStyle.VERTICAL_JUSTIFY);
		HSSFFont fuente = wb.createFont();
		fuente.setFontHeightInPoints((short) 9);
		styleTextoImpar.setFont(fuente);
			
		return styleTextoImpar;
	}  

	/**
	 * estiloCadenaAutoAjust
	 * 
	 * @param wb HSSFWorkbook
	 * @return HSSFCellStyle
	 */    
	public static HSSFCellStyle estiloCadenaAutoAjust (HSSFWorkbook wb){
		
		
		HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
		styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.	
		styleTextoImpar.setVerticalAlignment(HSSFCellStyle.VERTICAL_JUSTIFY);		
		
		 HSSFFont fuente = wb.createFont();
		fuente.setFontHeightInPoints((short) 10);
		styleTextoImpar.setFont(fuente);
			
		return styleTextoImpar;
	}     
   
   
    /**
	  * estiloInparCadena
	  * 
	  * @param wb HSSFWorkbook
	  * @return HSSFCellStyle
	  */    
   public static HSSFCellStyle estiloInparCadena (HSSFWorkbook wb){
   	
   	
     	HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
     	styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.			 
     	styleTextoImpar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
     	styleTextoImpar.setWrapText(true);
   	 HSSFFont fuente = wb.createFont();
	 fuente.setFontHeightInPoints((short) 8);
	 styleTextoImpar.setFont(fuente);
     	styleTextoImpar.setFillForegroundColor(GREY.index);
     	styleTextoImpar.setBorderRight((short) 1);
     	styleTextoImpar.setBorderLeft((short) 1);
     	styleTextoImpar.setBorderBottom((short) 1);
     	styleTextoImpar.setBorderTop((short) 1);
		return styleTextoImpar;
   }  
   
   /**
    * estiloInparCadena
    * 
    * @param wb HSSFWorkbook
    * @return HSSFCellStyle
    */    
   public static HSSFCellStyle estiloInparCadenaNoBordes (HSSFWorkbook wb){
	   
	   
	   HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
	   styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.			 
	   styleTextoImpar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	   styleTextoImpar.setWrapText(true);
	   HSSFFont fuente = wb.createFont();
	   fuente.setFontHeightInPoints((short) 8);
	   styleTextoImpar.setFont(fuente);
	   styleTextoImpar.setFillForegroundColor(GREY.index);
	   styleTextoImpar.setBorderRight((short) 0);
	   styleTextoImpar.setBorderLeft((short) 1);
	   styleTextoImpar.setBorderBottom((short) 2);
	   styleTextoImpar.setBorderTop((short) 3);
	   return styleTextoImpar;
   }       
   
   /**
	  * estiloInparCadenaCentrado
	  * 
	  * @param wb HSSFWorkbook
	  * @return HSSFCellStyle
	  */    
 public static HSSFCellStyle estiloInparCadenaCentrado (HSSFWorkbook wb){
 	
 	
   	HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
   	styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_CENTER); // Estilo alineacin dercecha.			 
   	styleTextoImpar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
   	styleTextoImpar.setWrapText(true);
 	 HSSFFont fuente = wb.createFont();
	 fuente.setFontHeightInPoints((short) 8);
	 styleTextoImpar.setFont(fuente);
   	styleTextoImpar.setFillForegroundColor(GREY.index);
   	styleTextoImpar.setBorderRight((short) 1);
   	styleTextoImpar.setBorderLeft((short) 1);
   	styleTextoImpar.setBorderBottom((short) 1);
   	styleTextoImpar.setBorderTop((short) 1);
		return styleTextoImpar;
 }    
   /**
    * estiloInparCadenaNoJustif
    * 
    * @param wb HSSFWorkbook
    * @return HSSFCellStyle
    */    
   public static HSSFCellStyle estiloInparCadenaNoJustif (HSSFWorkbook wb){
	   
	   
	   HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
	   styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.			 
	   styleTextoImpar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	   styleTextoImpar.setWrapText(false);
	   HSSFFont fuente = wb.createFont();
	   fuente.setFontHeightInPoints((short) 8);
	   styleTextoImpar.setFont(fuente);
	   styleTextoImpar.setFillForegroundColor(GREY.index);
	   styleTextoImpar.setBorderRight((short) 1);
	   styleTextoImpar.setBorderLeft((short) 1);
	   styleTextoImpar.setBorderBottom((short) 1);
	   styleTextoImpar.setBorderTop((short) 1);
	   
	   return styleTextoImpar;
   }    
   
   /**
    * estiloInparCadenaNoJustif
    * 
    * @param wb HSSFWorkbook
    * @return HSSFCellStyle
    */    
   public static HSSFCellStyle estiloInparCadenaJustifCombinada (HSSFWorkbook wb){
	   
	   
	   HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
	   styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_JUSTIFY); // Estilo alineacin dercecha.			 
	   styleTextoImpar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	   styleTextoImpar.setWrapText(false);
	   HSSFFont fuente = wb.createFont();
	   fuente.setFontHeightInPoints((short) 8);
	   styleTextoImpar.setFont(fuente);
	   styleTextoImpar.setFillForegroundColor(GREY.index);
	   styleTextoImpar.setBorderRight((short) 1);
	   styleTextoImpar.setBorderLeft((short) 1);
	   styleTextoImpar.setBorderBottom((short) 1);
	   styleTextoImpar.setBorderTop((short) 1);
	   styleTextoImpar.setVerticalAlignment(HSSFCellStyle.VERTICAL_TOP);
	   
	   return styleTextoImpar;
   }    
   
   
   /**
	  * estiloInparNumero
	  * 
	  * @param wb HSSFWorkbook
	  * @return HSSFCellStyle
	  */    
 public static HSSFCellStyle estiloInparNumero (HSSFWorkbook wb){
	
	HSSFDataFormat format = wb.createDataFormat();
   	HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
   	styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_RIGHT); // Estilo alineacin dercecha.			 
   	styleTextoImpar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	 HSSFFont fuente = wb.createFont();
	 fuente.setFontHeightInPoints((short) 8);
	 styleTextoImpar.setFont(fuente);
   	styleTextoImpar.setDataFormat(format.getFormat("0")); // Estilo de formato de nmero para que siempre saque como mnimo dos dgitos
   	styleTextoImpar.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
   	styleTextoImpar.setBorderRight((short) 1);
   	styleTextoImpar.setBorderLeft((short) 1);
   	styleTextoImpar.setBorderBottom((short) 1);
   	styleTextoImpar.setBorderTop((short) 1);

	return styleTextoImpar;
 }    
 /**
  * estiloInparNumero
  * 
  * @param wb HSSFWorkbook
  * @return HSSFCellStyle
  */    
public static HSSFCellStyle estiloInparNumeroCentrado (HSSFWorkbook wb){
	
	HSSFDataFormat format = wb.createDataFormat();
	HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
	styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_CENTER); // Estilo alineacin centrado.			 
	styleTextoImpar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	HSSFFont fuente = wb.createFont();
	fuente.setFontHeightInPoints((short) 8);
	styleTextoImpar.setFont(fuente);
	styleTextoImpar.setDataFormat(format.getFormat("0")); // Estilo de formato de nmero para que siempre saque como mnimo dos dgitos
	styleTextoImpar.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
	styleTextoImpar.setBorderRight((short) 1);
	styleTextoImpar.setBorderLeft((short) 1);
	styleTextoImpar.setBorderBottom((short) 1);
	styleTextoImpar.setBorderTop((short) 1);

return styleTextoImpar;
}    
 /**
  * estiloInparNumero
  *  * Define el formato para n decimales de modo 0.00
  * 
  * @param wb HSSFWorkbook
  * @return HSSFCellStyle
  */    
 public static HSSFCellStyle estiloInparNumeroFormato (HSSFWorkbook wb){
	 
	 HSSFDataFormat format = wb.createDataFormat();
	 HSSFCellStyle styleNumeroImparFormato =  wb.createCellStyle();
	 styleNumeroImparFormato.setAlignment(HSSFCellStyle.ALIGN_RIGHT); // Estilo alineacin dercecha.
	 HSSFFont fuente = wb.createFont();
	 fuente.setFontHeightInPoints((short) 8);
	 styleNumeroImparFormato.setFont(fuente);
	 styleNumeroImparFormato.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	 styleNumeroImparFormato.setDataFormat(format.getFormat("#,##0.00")); // Estilo de formato de nmero para que siempre saque como mnimo dos dgitos
	 styleNumeroImparFormato.setFillForegroundColor(GREY.index);
	 styleNumeroImparFormato.setBorderRight((short) 1);
	 styleNumeroImparFormato.setBorderLeft((short) 1);
	 styleNumeroImparFormato.setBorderBottom((short) 1);
	 styleNumeroImparFormato.setBorderTop((short) 1);
	 
	 return styleNumeroImparFormato;
 }    
 /**
  * estiloInparNumero
  *  * Define el formato para n decimales de modo 0.00
  * 
  * @param wb HSSFWorkbook
  * @return HSSFCellStyle
  */    
 public static HSSFCellStyle estiloInparNumeroPorcentaje (HSSFWorkbook wb){
	 
	 HSSFDataFormat format = wb.createDataFormat();
	 HSSFCellStyle styleNumeroImparFormato =  wb.createCellStyle();
	 styleNumeroImparFormato.setAlignment(HSSFCellStyle.ALIGN_RIGHT); // Estilo alineacin dercecha.
	 HSSFFont fuente = wb.createFont();
	 fuente.setFontHeightInPoints((short) 8);
	 styleNumeroImparFormato.setFont(fuente);
	 styleNumeroImparFormato.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	 styleNumeroImparFormato.setFillForegroundColor(GREY.index);
	 styleNumeroImparFormato.setBorderRight((short) 1);
	 styleNumeroImparFormato.setBorderLeft((short) 1);
	 styleNumeroImparFormato.setBorderBottom((short) 1);
	 styleNumeroImparFormato.setBorderTop((short) 1);
	 styleNumeroImparFormato.setDataFormat(format.getFormat("0.00%")); 
		 
	 return styleNumeroImparFormato;
 }    
 
 /**
  * estiloCabecera
  * 
  * @param wb HSSFWorkbook
  * @return HSSFCellStyle
  */    
public static HSSFCellStyle estiloCabecera (HSSFWorkbook wb){
	
	
 	HSSFCellStyle imparoscuro =  wb.createCellStyle();
 	
	imparoscuro = wb.createCellStyle();// Estilo
	imparoscuro.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	 HSSFFont fuente = wb.createFont();
	 fuente.setFontHeightInPoints((short) 8);
	 imparoscuro.setFont(fuente);
	imparoscuro.setFillForegroundColor(HSSFColor.GREY_40_PERCENT.index)	;	
	imparoscuro.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
	imparoscuro.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	imparoscuro.setWrapText(true);
	imparoscuro.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderRight(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderTop(HSSFCellStyle.BORDER_THIN);// centrado.

	return imparoscuro;
}

public static HSSFCellStyle estiloCabeceraIzquierda (HSSFWorkbook wb){
	
	
 	HSSFCellStyle imparoscuro =  wb.createCellStyle();
 	
	imparoscuro = wb.createCellStyle();// Estilo
	imparoscuro.setVerticalAlignment(HSSFCellStyle.VERTICAL_BOTTOM);
	imparoscuro.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	imparoscuro.setWrapText(true);
	
	return imparoscuro;
}

public static HSSFCellStyle estiloFilaJustificado(HSSFWorkbook wb){
	HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
	styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.	
	HSSFFont fuente = wb.createFont();
	fuente.setFontHeightInPoints((short) 9);
	styleNumeroPar.setFont(fuente);			 
	styleNumeroPar.setWrapText(true); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
	
	return styleNumeroPar;
}

public static HSSFCellStyle estiloExcelCitacionesTitulos(HSSFWorkbook wb){
	HSSFCellStyle estilo =  wb.createCellStyle();
	estilo.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.	
	HSSFFont fuente = wb.createFont();
	fuente.setFontHeightInPoints((short)16);
	fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	fuente.setFontName("Times New Roman");
	estilo.setWrapText(true); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
	estilo.setFont(fuente);	
	
	return estilo;
}

public static HSSFCellStyle estiloExcelCitaciones(HSSFWorkbook wb){
	HSSFCellStyle estilo =  wb.createCellStyle();
	estilo.setAlignment(HSSFCellStyle.ALIGN_LEFT); // Estilo alineacin dercecha.	
	HSSFFont fuente = wb.createFont();
	fuente.setFontHeightInPoints((short)16);
	fuente.setFontName("Times New Roman");
	estilo.setWrapText(true); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
	estilo.setFont(fuente);	
	
	return estilo;
}

public static HSSFCellStyle styleFuenteTexto(HSSFWorkbook wb){
	HSSFCellStyle estilo =  wb.createCellStyle();
	HSSFFont fuente = wb.createFont();
	fuente.setFontHeightInPoints((short)10);
	fuente.setFontName("Times New Roman");
	estilo.setWrapText(true); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
	estilo.setFont(fuente);	
	
	return estilo;
}

public static HSSFCellStyle estiloCabeceraBlancoTabla (HSSFWorkbook wb){
	
	HSSFCellStyle imparoscuro =  wb.createCellStyle();
 	
	imparoscuro = wb.createCellStyle();// Estilo
	imparoscuro.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	HSSFFont fuente = wb.createFont();
	fuente.setFontHeightInPoints((short) 10);
	imparoscuro.setFont(fuente);
	imparoscuro.setFillForegroundColor(HSSFColor.WHITE.index)	;	
	imparoscuro.setVerticalAlignment(HSSFCellStyle.VERTICAL_BOTTOM);
	imparoscuro.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	imparoscuro.setWrapText(true);
	imparoscuro.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderRight(HSSFCellStyle.NO_FILL);
	imparoscuro.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderTop(HSSFCellStyle.NO_FILL);// centrado.

	return imparoscuro;
} 

public static HSSFCellStyle estiloCabeceraTabla (HSSFWorkbook wb){
	
	HSSFCellStyle imparoscuro =  wb.createCellStyle();
 	
	imparoscuro = wb.createCellStyle();// Estilo
	imparoscuro.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	HSSFFont fuente = wb.createFont();
	fuente.setFontHeightInPoints((short) 10);
	imparoscuro.setFont(fuente);
	imparoscuro.setFillForegroundColor(HSSFColor.GREY_40_PERCENT.index)	;	
	imparoscuro.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
	imparoscuro.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	imparoscuro.setWrapText(true);
	imparoscuro.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderRight(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderTop(HSSFCellStyle.BORDER_THIN);// centrado.

	return imparoscuro;
}
/**
 * estiloCabecera
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */    
public static HSSFCellStyle estiloCabeceraClara (HSSFWorkbook wb){
	
	
	HSSFCellStyle imparoscuro =  wb.createCellStyle();
	
	imparoscuro = wb.createCellStyle();// Estilo
	imparoscuro.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	 HSSFFont fuente = wb.createFont();
	 fuente.setFontHeightInPoints((short) 8);
	 imparoscuro.setFont(fuente);
	imparoscuro.setFillForegroundColor(GREY.index)	;	
	imparoscuro.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
	imparoscuro.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	imparoscuro.setWrapText(true);
	imparoscuro.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderRight(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderTop(HSSFCellStyle.BORDER_THIN);// centrado.
	
	return imparoscuro;
}  
/**
 * estiloCabecera
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */    
public static HSSFCellStyle estiloCabeceraBlanca (HSSFWorkbook wb){
	
	
	HSSFCellStyle imparoscuro =  wb.createCellStyle();
	
	imparoscuro = wb.createCellStyle();// Estilo
	imparoscuro.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	imparoscuro.setFillForegroundColor(HSSFColor.GREY_40_PERCENT.index)	;	
	imparoscuro.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
	
	imparoscuro.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	imparoscuro.setWrapText(true);
	HSSFFont fuente = wb.createFont();
	fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	fuente.setColor((short)1);//valores:1-blanco;2-rojo;3-verde
	fuente.setFontHeight((short)8);
	imparoscuro.setFont(fuente);
	imparoscuro.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderRight(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderTop(HSSFCellStyle.BORDER_THIN);// centrado.

	return imparoscuro;
}  

/**
 * estiloCabeceraNumero
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */    
public static HSSFCellStyle estiloCabeceraNumero (HSSFWorkbook wb){
	
	
	HSSFCellStyle imparoscuro =  wb.createCellStyle();
	
	imparoscuro = wb.createCellStyle();// Estilo
	imparoscuro.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	imparoscuro.setFillForegroundColor(HSSFColor.GREY_40_PERCENT.index)	;	
	imparoscuro.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
	 HSSFFont fuente = wb.createFont();
	 fuente.setFontHeightInPoints((short) 8);
	 imparoscuro.setFont(fuente);
	imparoscuro.setAlignment(HSSFCellStyle.ALIGN_RIGHT); // Estilo alineacin dercecha.	
	imparoscuro.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderRight(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	imparoscuro.setBorderTop(HSSFCellStyle.BORDER_THIN);// centrado.

	return imparoscuro;
}  
/**
 * @param wb
 * @return
 */
public static HSSFCellStyle estiloNegrita (HSSFWorkbook wb){
	
	HSSFCellStyle negrita =  wb.createCellStyle();
	HSSFFont fuente = wb.createFont();
	 fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	 negrita = wb.createCellStyle();// Estilo
	 negrita.setFont(fuente);
	return negrita;
}
/**
 * @param wb
 * @return
 */
public static HSSFCellStyle estiloNegritaBordeIzq (HSSFWorkbook wb){
	
	HSSFCellStyle negrita =  wb.createCellStyle();
	HSSFFont fuente = wb.createFont();
	 fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	 negrita = wb.createCellStyle();// Estilo
	 negrita.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	 negrita.setFont(fuente);
	return negrita;
}
/**
 * @param wb
 * @return
 */
public static HSSFCellStyle estiloNegritaBordeAbajoIzq (HSSFWorkbook wb){
	
	HSSFCellStyle negrita =  wb.createCellStyle();
	HSSFFont fuente = wb.createFont();
	fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	negrita = wb.createCellStyle();// Estilo
	negrita.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	negrita.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	negrita.setFont(fuente);
	return negrita;
}
/**
 * estiloNegritaSubrayado
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */ 
public static HSSFCellStyle estiloNegritaSubrayado (HSSFWorkbook wb){
	
	
	HSSFCellStyle negritasub =  wb.createCellStyle();
	
	HSSFFont fuente = wb.createFont();
	 fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	 fuente.setUnderline(HSSFFont.U_SINGLE);
	 negritasub.setFont(fuente);

	return negritasub;
}  
/**
 * estiloNegritaSubrayadoCentrado
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */ 
public static HSSFCellStyle estiloNegritaSubrayadoCentrado (HSSFWorkbook wb){
	
	
	HSSFCellStyle negritasub =  wb.createCellStyle();
	
	HSSFFont fuente = wb.createFont();
	 fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	 negritasub.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
	 fuente.setUnderline(HSSFFont.U_SINGLE);
	 negritasub.setFont(fuente);

	return negritasub;
}

/**
 * estiloNegritaSubrayado
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */ 
public static HSSFCellStyle estiloNegritaSubrayadoTabla (HSSFWorkbook wb){
	
	
	HSSFCellStyle negritasub =  wb.createCellStyle();
	
	HSSFFont fuente = wb.createFont();
	 fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	 fuente.setUnderline(HSSFFont.U_SINGLE);
	 negritasub.setFont(fuente);
	 negritasub.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	 negritasub.setBorderTop(HSSFCellStyle.BORDER_THIN);// centrado.

	return negritasub;
} 

/**
 * estiloOcultoNumero
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */    
public static HSSFCellStyle estiloOcultoNumero (HSSFWorkbook wb){
	
	
	HSSFCellStyle estilo =  wb.createCellStyle();
	
	estilo = wb.createCellStyle();// Estilo
	estilo.setHidden(true);	
	HSSFFont f = wb.createFont();
	HSSFColor s =  new HSSFColor.WHITE();
	f.setColor(s.getIndex());
	estilo.setFont(f);

	return estilo;
}  


/**
 * tipoFilaCadena.
 * @param fila int 
 * @param wb HSSFWorkbook 
 * @return HSSFCellStyle
 */
public static HSSFCellStyle tipoFilaCadena(int fila,HSSFWorkbook wb)
{
	if (fila % 2 == 0)
	{
		return W83aClsEstilosExcel.estiloParCadena(wb);
	}
	else
	{
		return W83aClsEstilosExcel.estiloInparCadena(wb);
	}
}

/**
 * tipoFilaNumero.
 * @param fila int
 * @param wb HSSFWorkbook 
 * @return HSSFCellStyle
 */
public static HSSFCellStyle tipoFilaNumero(int fila,HSSFWorkbook wb)
{
	if (fila % 2 == 0)
	{
		return W83aClsEstilosExcel.estiloParNumero(wb);
	}
	else
	{
		return W83aClsEstilosExcel.estiloInparNumero(wb);
	}
}

/**
 * styleBordeArriba
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */ 
public static HSSFCellStyle styleBordeAbajo (HSSFWorkbook wb){
	
	HSSFCellStyle bordeAbajo =  wb.createCellStyle();
	
	bordeAbajo = wb.createCellStyle();// Estilo
	bordeAbajo.setBorderBottom(HSSFCellStyle.BORDER_THIN);

	return bordeAbajo;
}  
  
/**
 * styleBordeArriba
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */ 
public static HSSFCellStyle styleBordeAbajoDcha (HSSFWorkbook wb){
	
	HSSFCellStyle bordeAbajo =  wb.createCellStyle();
	
	bordeAbajo = wb.createCellStyle();// Estilo
	bordeAbajo.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	bordeAbajo.setBorderRight(HSSFCellStyle.BORDER_THIN);
	return bordeAbajo;
}  
/**
 * styleBordeArriba
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */ 
public static HSSFCellStyle styleBordeAbajoDchaArriba (HSSFWorkbook wb){
	
	HSSFCellStyle bordeAbajo =  wb.createCellStyle();
	
	bordeAbajo = wb.createCellStyle();// Estilo
	bordeAbajo.setBorderBottom(HSSFCellStyle.BORDER_THIN);
	bordeAbajo.setBorderRight(HSSFCellStyle.BORDER_THIN);
	bordeAbajo.setBorderTop(HSSFCellStyle.BORDER_THIN);
	return bordeAbajo;
}  
/**
 * styleBordeArriba
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */ 
public static HSSFCellStyle styleBordeArriba (HSSFWorkbook wb){
	
	HSSFCellStyle bordeArriba =  wb.createCellStyle();
	
	bordeArriba = wb.createCellStyle();// Estilo
	bordeArriba.setBorderTop(HSSFCellStyle.BORDER_THIN);

	return bordeArriba;
} 

/**
 * stylePorcentajesDcha
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */ 
public static HSSFCellStyle stylePorcentajesDcha (HSSFWorkbook wb){
	
	HSSFCellStyle styleNumero =  wb.createCellStyle();
	HSSFDataFormat format = wb.createDataFormat();
	styleNumero.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
	styleNumero.setDataFormat(format.getFormat("#,##0.00%"));
	return styleNumero;
} 

/**
 * @param wb
 * @return
 */
public static HSSFCellStyle styleBordeDcha (HSSFWorkbook wb){
	
	HSSFCellStyle bordeArriba =  wb.createCellStyle();
	
	bordeArriba = wb.createCellStyle();// Estilo
	bordeArriba.setBorderRight(HSSFCellStyle.BORDER_THIN);

	return bordeArriba;
} 
/**
 * @param wb
 * @return
 */
public static HSSFCellStyle styleBordeDchaArriba (HSSFWorkbook wb){
	
	HSSFCellStyle bordeArriba =  wb.createCellStyle();
	
	bordeArriba = wb.createCellStyle();// Estilo
	bordeArriba.setBorderRight(HSSFCellStyle.BORDER_THIN);
	bordeArriba.setBorderTop(HSSFCellStyle.BORDER_THIN);

	return bordeArriba;
} 
/**
 * @param wb
 * @return
 */
public static HSSFCellStyle styleBordeDchaAbajo (HSSFWorkbook wb){
	
	HSSFCellStyle bordeArriba =  wb.createCellStyle();
	
	bordeArriba = wb.createCellStyle();// Estilo
	bordeArriba.setBorderRight(HSSFCellStyle.BORDER_THIN);
	bordeArriba.setBorderBottom(HSSFCellStyle.BORDER_THIN);

	return bordeArriba;
} 

/**
 * @param wb
 * @return
 */
public static HSSFCellStyle styleBordeIzda (HSSFWorkbook wb){
	
	HSSFCellStyle bordeArriba =  wb.createCellStyle();
	
	bordeArriba = wb.createCellStyle();// Estilo
	bordeArriba.setBorderLeft(HSSFCellStyle.BORDER_THIN);

	return bordeArriba;
} 
/**
 * @param wb
 * @return
 */
public static HSSFCellStyle styleBordeIzdaArriba (HSSFWorkbook wb){
	
	HSSFCellStyle bordeArriba =  wb.createCellStyle();
	
	bordeArriba = wb.createCellStyle();// Estilo
	bordeArriba.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	bordeArriba.setBorderTop(HSSFCellStyle.BORDER_THIN);

	return bordeArriba;
} 
/**
 * @param wb
 * @return
 */
public static HSSFCellStyle styleBordeIzdaArribanegrita (HSSFWorkbook wb){
	
	HSSFCellStyle bordeArriba =  wb.createCellStyle();
	HSSFFont fuente = wb.createFont();
	 fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
	bordeArriba = wb.createCellStyle();// Estilo
	 bordeArriba.setFont(fuente);
	bordeArriba.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	bordeArriba.setBorderTop(HSSFCellStyle.BORDER_THIN);

	return bordeArriba;
} 
/**
 * @param wb
 * @return
 */
public static HSSFCellStyle styleBordeIzdaAbajo (HSSFWorkbook wb){
	
	HSSFCellStyle bordeArriba =  wb.createCellStyle();
	
	bordeArriba = wb.createCellStyle();// Estilo
	bordeArriba.setBorderLeft(HSSFCellStyle.BORDER_THIN);
	bordeArriba.setBorderBottom(HSSFCellStyle.BORDER_THIN);

	return bordeArriba;
} 
public static HSSFCellStyle styleCentrado (HSSFWorkbook wb){
	
	HSSFCellStyle centrado =  wb.createCellStyle();
	
	centrado = wb.createCellStyle();// Estilo
	centrado.setAlignment(HSSFCellStyle.ALIGN_CENTER);

	return centrado;
} 

public static HSSFCellStyle styleCentradoSubrayado (HSSFWorkbook wb){
	
	HSSFCellStyle centrado =  wb.createCellStyle();
	
	centrado = wb.createCellStyle();// Estilo
	centrado.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	centrado.setBorderBottom(HSSFCellStyle.BORDER_THIN);

	return centrado;
} 

public static HSSFCellStyle styleCentradoImpar (HSSFWorkbook wb){
	
	HSSFCellStyle centrado =  wb.createCellStyle();
	
	centrado = wb.createCellStyle();// Estilo
	centrado.setAlignment(HSSFCellStyle.ALIGN_CENTER);
	centrado.setFillForegroundColor(GREY.index);

	return centrado;
} 

public static final class GREY extends HSSFColor{
	public static final short index = 22;
	public static final short[] triplet = { 216, 216, 216 };
	public static final String hexString = "C0C0:C0C0:C0C0";
	
	public short getIndex(){
		return 22;
	}
	
	public short[] getTriplet(){
		return triplet;
	}
	
	public String getHexString(){
		return "C0C0:C0C0:C0C0";
	}
}

/**
 * styleTextoImparCentrado
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */    
public static HSSFCellStyle styleTextoImparCentrado (HSSFWorkbook wb){
	
	
	HSSFCellStyle styleTextoImpar =  wb.createCellStyle();
 	styleTextoImpar.setAlignment(HSSFCellStyle.ALIGN_CENTER); // Estilo alineacin dercecha.			 
 	styleTextoImpar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
 	styleTextoImpar.setWrapText(true);
	HSSFFont fuente = wb.createFont();
	fuente.setFontHeightInPoints((short) 8);
	styleTextoImpar.setFont(fuente);
 	styleTextoImpar.setFillForegroundColor(GREY.index);
 	styleTextoImpar.setBorderRight((short) 1);
 	styleTextoImpar.setBorderLeft((short) 1);
 	styleTextoImpar.setBorderBottom((short) 1);
 	styleTextoImpar.setBorderTop((short) 1);
	return styleTextoImpar;
}     
/**
 * styleTextoImparCentrado
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */    
public static HSSFCellStyle styleTextoParCentrado (HSSFWorkbook wb){
	
	
	HSSFCellStyle styleNumeroPar =  wb.createCellStyle();
	styleNumeroPar.setAlignment(HSSFCellStyle.ALIGN_CENTER); // Estilo alineacin dercecha.	
	HSSFFont fuente = wb.createFont();
	fuente.setFontHeightInPoints((short) 8);
	styleNumeroPar.setFont(fuente);			 
	styleNumeroPar.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	styleNumeroPar.setWrapText(true); //Ajustar texto al tamao de la celda (la celda crecera a lo alto)
	styleNumeroPar.setFillForegroundColor(HSSFColor.WHITE.index);
	styleNumeroPar.setBorderRight((short) 1);
	styleNumeroPar.setBorderLeft((short) 1);
	styleNumeroPar.setBorderBottom((short) 1);
	styleNumeroPar.setBorderTop((short) 1);
	
	return styleNumeroPar;
}     

/**
 * estiloParNumeroFormato
 * Define el formato para n decimales de modo 0.00
 * 
 * @param wb HSSFWorkbook
 * @return HSSFCellStyle
 */    
public static HSSFCellStyle estiloNumero (HSSFWorkbook wb){
	   
	   HSSFDataFormat format = wb.createDataFormat();
	   HSSFCellStyle styleNumeroParFormato =  wb.createCellStyle();
	   styleNumeroParFormato.setAlignment(HSSFCellStyle.ALIGN_RIGHT); // Estilo alineacin dercecha.
		 HSSFFont fuente = wb.createFont();
		 fuente.setFontHeightInPoints((short) 10);
		 styleNumeroParFormato.setFont(fuente);
	   styleNumeroParFormato.setDataFormat(format.getFormat("#,##0")); // Estilo de formato de nmero para que siempre saque como mnimo dos dgitos
	 
	   
	   return styleNumeroParFormato;
}    
public static HSSFCellStyle estiloNumeroBordeArriba (HSSFWorkbook wb){
	
	HSSFDataFormat format = wb.createDataFormat();
	HSSFCellStyle styleNumeroParFormato =  wb.createCellStyle();
	styleNumeroParFormato.setAlignment(HSSFCellStyle.ALIGN_RIGHT); // Estilo alineacin dercecha.
	HSSFFont fuente = wb.createFont();
	fuente.setFontHeightInPoints((short) 10);
	styleNumeroParFormato.setFont(fuente);
	styleNumeroParFormato.setDataFormat(format.getFormat("#,##0")); // Estilo de formato de nmero para que siempre saque como mnimo dos dgitos
	
	styleNumeroParFormato.setBorderTop((short) 1);
	
	return styleNumeroParFormato;
}    

}

